/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ElementValue;
import java.io.DataOutputStream;
import java.io.IOException;

public class ArrayElementValue
extends ElementValue {
    private final ElementValue[] evalues;

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < this.evalues.length; ++i) {
            stringBuilder.append(this.evalues[i]);
            if (i + 1 >= this.evalues.length) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public ArrayElementValue(int n, ElementValue[] elementValueArray, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 91) {
            throw new RuntimeException("Only element values of type array can be built with this ctor - type specified: " + n);
        }
        this.evalues = elementValueArray;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getType());
        dataOutputStream.writeShort(this.evalues.length);
        for (ElementValue elementValue : this.evalues) {
            elementValue.dump(dataOutputStream);
        }
    }

    @Override
    public String stringifyValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < this.evalues.length; ++i) {
            stringBuilder.append(this.evalues[i].stringifyValue());
            if (i + 1 >= this.evalues.length) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public ElementValue[] getElementValuesArray() {
        return this.evalues;
    }

    public int getElementValuesArraySize() {
        return this.evalues.length;
    }
}

