/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.Code;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.ExceptionTable;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.LineNumberTable;
import com.sun.org.apache.bcel.internal.classfile.LocalVariableTable;
import com.sun.org.apache.bcel.internal.classfile.ParameterAnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.io.DataInput;
import java.io.IOException;

public final class Method
extends FieldOrMethod {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            Method method = (Method)object;
            Method method2 = (Method)object2;
            return method.getName().equals(method2.getName()) && method.getSignature().equals(method2.getSignature());
        }

        @Override
        public int hashCode(Object object) {
            Method method = (Method)object;
            return method.getSignature().hashCode() ^ method.getName().hashCode();
        }
    };
    private ParameterAnnotationEntry[] parameterAnnotationEntries;

    public Method() {
    }

    public Method(Method method) {
        super(method);
    }

    Method(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFormatException {
        super(dataInput, constantPool);
    }

    public Method(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n, n2, n3, attributeArray, constantPool);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMethod(this);
    }

    public final Code getCode() {
        for (Attribute attribute : super.getAttributes()) {
            if (!(attribute instanceof Code)) continue;
            return (Code)attribute;
        }
        return null;
    }

    public final ExceptionTable getExceptionTable() {
        for (Attribute attribute : super.getAttributes()) {
            if (!(attribute instanceof ExceptionTable)) continue;
            return (ExceptionTable)attribute;
        }
        return null;
    }

    public final LocalVariableTable getLocalVariableTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLocalVariableTable();
    }

    public final LineNumberTable getLineNumberTable() {
        Code code = this.getCode();
        if (code == null) {
            return null;
        }
        return code.getLineNumberTable();
    }

    public final String toString() {
        String string;
        String string2 = Utility.accessToString(super.getAccessFlags());
        ConstantUtf8 constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(super.getSignatureIndex(), (byte)1);
        String string3 = constantUtf8.getBytes();
        constantUtf8 = (ConstantUtf8)super.getConstantPool().getConstant(super.getNameIndex(), (byte)1);
        String string4 = constantUtf8.getBytes();
        string3 = Utility.methodSignatureToString(string3, string4, string2, true, this.getLocalVariableTable());
        StringBuilder stringBuilder = new StringBuilder(string3);
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof Code || attribute instanceof ExceptionTable) continue;
            stringBuilder.append(" [").append(attribute).append("]");
        }
        ExceptionTable exceptionTable = this.getExceptionTable();
        if (exceptionTable != null && !(string = exceptionTable.toString()).isEmpty()) {
            stringBuilder.append("\n\t\tthrows ").append(string);
        }
        return stringBuilder.toString();
    }

    public final Method copy(ConstantPool constantPool) {
        return (Method)this.copy_(constantPool);
    }

    public Type getReturnType() {
        return Type.getReturnType(this.getSignature());
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes(this.getSignature());
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        bcelComparator = bCELComparator;
    }

    public boolean equals(Object object) {
        return bcelComparator.equals(this, object);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }

    public ParameterAnnotationEntry[] getParameterAnnotationEntries() {
        if (this.parameterAnnotationEntries == null) {
            this.parameterAnnotationEntries = ParameterAnnotationEntry.createParameterAnnotationEntries(this.getAttributes());
        }
        return this.parameterAnnotationEntries;
    }
}

