/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Annotations;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Field;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.RuntimeInvisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.RuntimeVisibleAnnotations;
import com.sun.org.apache.bcel.internal.classfile.SourceFile;
import com.sun.org.apache.bcel.internal.generic.AnnotationEntryGen;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ClassObserver;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.util.ArrayList;
import java.util.List;

public class ClassGen
extends AccessFlags
implements Cloneable {
    private String class_name;
    private String super_class_name;
    private final String file_name;
    private int class_name_index = -1;
    private int superclass_name_index = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPoolGen cp;
    private final List<Field> field_vec = new ArrayList<Field>();
    private final List<Method> method_vec = new ArrayList<Method>();
    private final List<Attribute> attribute_vec = new ArrayList<Attribute>();
    private final List<String> interface_vec = new ArrayList<String>();
    private final List<AnnotationEntryGen> annotation_vec = new ArrayList<AnnotationEntryGen>();
    private static BCELComparator _cmp = new BCELComparator(){

        @Override
        public boolean equals(Object object, Object object2) {
            ClassGen classGen = (ClassGen)object;
            ClassGen classGen2 = (ClassGen)object2;
            return classGen.getClassName().equals(classGen2.getClassName());
        }

        @Override
        public int hashCode(Object object) {
            ClassGen classGen = (ClassGen)object;
            return classGen.getClassName().hashCode();
        }
    };
    private List<ClassObserver> observers;

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray, ConstantPoolGen constantPoolGen) {
        super(n);
        this.class_name = string;
        this.super_class_name = string2;
        this.file_name = string3;
        this.cp = constantPoolGen;
        if (string3 != null) {
            this.addAttribute(new SourceFile(constantPoolGen.addUtf8("SourceFile"), 2, constantPoolGen.addUtf8(string3), constantPoolGen.getConstantPool()));
        }
        this.class_name_index = constantPoolGen.addClass(string);
        this.superclass_name_index = constantPoolGen.addClass(string2);
        if (stringArray != null) {
            for (String string4 : stringArray) {
                this.addInterface(string4);
            }
        }
    }

    public ClassGen(String string, String string2, String string3, int n, String[] stringArray) {
        this(string, string2, string3, n, stringArray, new ConstantPoolGen());
    }

    public ClassGen(JavaClass javaClass) {
        super(javaClass.getAccessFlags());
        this.class_name_index = javaClass.getClassNameIndex();
        this.superclass_name_index = javaClass.getSuperclassNameIndex();
        this.class_name = javaClass.getClassName();
        this.super_class_name = javaClass.getSuperclassName();
        this.file_name = javaClass.getSourceFileName();
        this.cp = new ConstantPoolGen(javaClass.getConstantPool());
        this.major = javaClass.getMajor();
        this.minor = javaClass.getMinor();
        Attribute[] attributeArray = javaClass.getAttributes();
        AnnotationEntryGen[] annotationEntryGenArray = this.unpackAnnotations(attributeArray);
        Method[] methodArray = javaClass.getMethods();
        Field[] fieldArray = javaClass.getFields();
        String[] stringArray = javaClass.getInterfaceNames();
        for (String object : stringArray) {
            this.addInterface(object);
        }
        for (Attribute attribute : attributeArray) {
            if (attribute instanceof Annotations) continue;
            this.addAttribute(attribute);
        }
        for (AnnotationEntryGen annotationEntryGen : annotationEntryGenArray) {
            this.addAnnotationEntry(annotationEntryGen);
        }
        for (Method method : methodArray) {
            this.addMethod(method);
        }
        for (Field field : fieldArray) {
            this.addField(field);
        }
    }

    private AnnotationEntryGen[] unpackAnnotations(Attribute[] attributeArray) {
        ArrayList<AnnotationEntryGen> arrayList = new ArrayList<AnnotationEntryGen>();
        for (Attribute attribute : attributeArray) {
            AnnotationEntry[] annotationEntryArray;
            Annotations annotations;
            if (attribute instanceof RuntimeVisibleAnnotations) {
                annotations = (RuntimeVisibleAnnotations)attribute;
                for (AnnotationEntry annotationEntry : annotationEntryArray = annotations.getAnnotationEntries()) {
                    arrayList.add(new AnnotationEntryGen(annotationEntry, this.getConstantPool(), false));
                }
                continue;
            }
            if (!(attribute instanceof RuntimeInvisibleAnnotations)) continue;
            annotations = (RuntimeInvisibleAnnotations)attribute;
            for (AnnotationEntry annotationEntry : annotationEntryArray = annotations.getAnnotationEntries()) {
                arrayList.add(new AnnotationEntryGen(annotationEntry, this.getConstantPool(), false));
            }
        }
        return arrayList.toArray(new AnnotationEntryGen[arrayList.size()]);
    }

    public JavaClass getJavaClass() {
        Object object;
        Attribute[] attributeArray;
        int[] nArray = this.getInterfaces();
        Field[] fieldArray = this.getFields();
        Method[] methodArray = this.getMethods();
        if (this.annotation_vec.isEmpty()) {
            attributeArray = this.getAttributes();
        } else {
            object = AnnotationEntryGen.getAnnotationAttributes(this.cp, this.getAnnotationEntries());
            attributeArray = new Attribute[this.attribute_vec.size() + ((Attribute[])object).length];
            this.attribute_vec.toArray(attributeArray);
            System.arraycopy(object, 0, attributeArray, this.attribute_vec.size(), ((Attribute[])object).length);
        }
        object = this.cp.getFinalConstantPool();
        return new JavaClass(this.class_name_index, this.superclass_name_index, this.file_name, this.major, this.minor, super.getAccessFlags(), (ConstantPool)object, nArray, fieldArray, methodArray, attributeArray);
    }

    public final void addInterface(String string) {
        this.interface_vec.add(string);
    }

    public void removeInterface(String string) {
        this.interface_vec.remove(string);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int n) {
        this.major = n;
    }

    public void setMinor(int n) {
        this.minor = n;
    }

    public int getMinor() {
        return this.minor;
    }

    public final void addAttribute(Attribute attribute) {
        this.attribute_vec.add(attribute);
    }

    public final void addAnnotationEntry(AnnotationEntryGen annotationEntryGen) {
        this.annotation_vec.add(annotationEntryGen);
    }

    public final void addMethod(Method method) {
        this.method_vec.add(method);
    }

    public void addEmptyConstructor(int n) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(InstructionConst.THIS);
        instructionList.append(new INVOKESPECIAL(this.cp.addMethodref(this.super_class_name, "<init>", "()V")));
        instructionList.append(InstructionConst.RETURN);
        MethodGen methodGen = new MethodGen(n, Type.VOID, Type.NO_ARGS, null, "<init>", this.class_name, instructionList, this.cp);
        methodGen.setMaxStack(1);
        this.addMethod(methodGen.getMethod());
    }

    public final void addField(Field field) {
        this.field_vec.add(field);
    }

    public boolean containsField(Field field) {
        return this.field_vec.contains(field);
    }

    public Field containsField(String string) {
        for (Field field : this.field_vec) {
            if (!field.getName().equals(string)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String string, String string2) {
        for (Method method : this.method_vec) {
            if (!method.getName().equals(string) || !method.getSignature().equals(string2)) continue;
            return method;
        }
        return null;
    }

    public void removeAttribute(Attribute attribute) {
        this.attribute_vec.remove(attribute);
    }

    public void removeMethod(Method method) {
        this.method_vec.remove(method);
    }

    public void replaceMethod(Method method, Method method2) {
        if (method2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.method_vec.indexOf(method);
        if (n < 0) {
            this.method_vec.add(method2);
        } else {
            this.method_vec.set(n, method2);
        }
    }

    public void replaceField(Field field, Field field2) {
        if (field2 == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int n = this.field_vec.indexOf(field);
        if (n < 0) {
            this.field_vec.add(field2);
        } else {
            this.field_vec.set(n, field2);
        }
    }

    public void removeField(Field field) {
        this.field_vec.remove(field);
    }

    public String getClassName() {
        return this.class_name;
    }

    public String getSuperclassName() {
        return this.super_class_name;
    }

    public String getFileName() {
        return this.file_name;
    }

    public void setClassName(String string) {
        this.class_name = string.replace('/', '.');
        this.class_name_index = this.cp.addClass(string);
    }

    public void setSuperclassName(String string) {
        this.super_class_name = string.replace('/', '.');
        this.superclass_name_index = this.cp.addClass(string);
    }

    public Method[] getMethods() {
        return this.method_vec.toArray(new Method[this.method_vec.size()]);
    }

    public void setMethods(Method[] methodArray) {
        this.method_vec.clear();
        for (Method method : methodArray) {
            this.addMethod(method);
        }
    }

    public void setMethodAt(Method method, int n) {
        this.method_vec.set(n, method);
    }

    public Method getMethodAt(int n) {
        return this.method_vec.get(n);
    }

    public String[] getInterfaceNames() {
        int n = this.interface_vec.size();
        String[] stringArray = new String[n];
        this.interface_vec.toArray(stringArray);
        return stringArray;
    }

    public int[] getInterfaces() {
        int n = this.interface_vec.size();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.cp.addClass(this.interface_vec.get(i));
        }
        return nArray;
    }

    public Field[] getFields() {
        return this.field_vec.toArray(new Field[this.field_vec.size()]);
    }

    public Attribute[] getAttributes() {
        return this.attribute_vec.toArray(new Attribute[this.attribute_vec.size()]);
    }

    public AnnotationEntryGen[] getAnnotationEntries() {
        return this.annotation_vec.toArray(new AnnotationEntryGen[this.annotation_vec.size()]);
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    public void setClassNameIndex(int n) {
        this.class_name_index = n;
        this.class_name = this.cp.getConstantPool().getConstantString(n, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int n) {
        this.superclass_name_index = n;
        this.super_class_name = this.cp.getConstantPool().getConstantString(n, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclass_name_index;
    }

    public int getClassNameIndex() {
        return this.class_name_index;
    }

    public void addObserver(ClassObserver classObserver) {
        if (this.observers == null) {
            this.observers = new ArrayList<ClassObserver>();
        }
        this.observers.add(classObserver);
    }

    public void removeObserver(ClassObserver classObserver) {
        if (this.observers != null) {
            this.observers.remove(classObserver);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (ClassObserver classObserver : this.observers) {
                classObserver.notify(this);
            }
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    public static BCELComparator getComparator() {
        return _cmp;
    }

    public static void setComparator(BCELComparator bCELComparator) {
        _cmp = bCELComparator;
    }

    public boolean equals(Object object) {
        return _cmp.equals(this, object);
    }

    public int hashCode() {
        return _cmp.hashCode(this);
    }
}

