/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class IINC
extends LocalVariableInstruction {
    private boolean wide;
    private int c;

    IINC() {
    }

    public IINC(int n, int n2) {
        super.setOpcode((short)132);
        super.setLength(3);
        this.setIndex(n);
        this.setIncrement(n2);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(super.getOpcode());
        if (this.wide) {
            dataOutputStream.writeShort(super.getIndex());
            dataOutputStream.writeShort(this.c);
        } else {
            dataOutputStream.writeByte(super.getIndex());
            dataOutputStream.writeByte(this.c);
        }
    }

    private void setWide() {
        boolean bl = this.wide = super.getIndex() > 255 || Math.abs(this.c) > 127;
        if (this.wide) {
            super.setLength(6);
        } else {
            super.setLength(3);
        }
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        this.wide = bl;
        if (bl) {
            super.setLength(6);
            super.setIndexOnly(byteSequence.readUnsignedShort());
            this.c = byteSequence.readShort();
        } else {
            super.setLength(3);
            super.setIndexOnly(byteSequence.readUnsignedByte());
            this.c = byteSequence.readByte();
        }
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.c;
    }

    @Override
    public final void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        super.setIndexOnly(n);
        this.setWide();
    }

    public final int getIncrement() {
        return this.c;
    }

    public final void setIncrement(int n) {
        this.c = n;
        this.setWide();
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        return Type.INT;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableInstruction(this);
        visitor.visitIINC(this);
    }
}

