/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;

public class US_ASCII
extends Charset
implements HistoricallyNamedCharset {
    public US_ASCII() {
        super("US-ASCII", StandardCharsets.aliases_US_ASCII);
    }

    @Override
    public String historicalName() {
        return "ASCII";
    }

    @Override
    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Decoder
    extends CharsetDecoder
    implements ArrayDecoder {
        private char repl = (char)65533;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            byte[] byArray = byteBuffer.array();
            int n = byteBuffer.arrayOffset() + byteBuffer.position();
            int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n <= n2);
            char[] cArray = charBuffer.array();
            int n3 = charBuffer.arrayOffset() + charBuffer.position();
            int n4 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                for (n = n <= n2 ? n : n2; n < n2; ++n) {
                    byte by = byArray[n];
                    if (by >= 0) {
                        if (n3 >= n4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = (char)by;
                        continue;
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n - byteBuffer.arrayOffset());
                charBuffer.position(n3 - charBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                while (byteBuffer.hasRemaining()) {
                    byte by = byteBuffer.get();
                    if (by >= 0) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)by);
                        ++n;
                        continue;
                    }
                    CoderResult coderResult = CoderResult.malformedForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.hasArray() && charBuffer.hasArray()) {
                return this.decodeArrayLoop(byteBuffer, charBuffer);
            }
            return this.decodeBufferLoop(byteBuffer, charBuffer);
        }

        @Override
        protected void implReplaceWith(String string) {
            this.repl = string.charAt(0);
        }

        @Override
        public int decode(byte[] byArray, int n, int n2, char[] cArray) {
            int n3 = 0;
            n2 = Math.min(n2, cArray.length);
            while (n3 < n2) {
                byte by;
                if ((by = byArray[n++]) >= 0) {
                    cArray[n3++] = (char)by;
                    continue;
                }
                cArray[n3++] = this.repl;
            }
            return n3;
        }
    }

    private static class Encoder
    extends CharsetEncoder
    implements ArrayEncoder {
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private byte repl = (byte)63;

        private Encoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return c < '\u0080';
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return byArray.length == 1 && byArray[0] >= 0 || super.isLegalReplacement(byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            char[] cArray = charBuffer.array();
            int n = charBuffer.arrayOffset() + charBuffer.position();
            int n2 = charBuffer.arrayOffset() + charBuffer.limit();
            assert (n <= n2);
            n = n <= n2 ? n : n2;
            byte[] byArray = byteBuffer.array();
            int n3 = byteBuffer.arrayOffset() + byteBuffer.position();
            int n4 = byteBuffer.arrayOffset() + byteBuffer.limit();
            assert (n3 <= n4);
            n3 = n3 <= n4 ? n3 : n4;
            try {
                while (n < n2) {
                    char c = cArray[n];
                    if (c < '\u0080') {
                        if (n3 >= n4) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byArray[n3] = (byte)c;
                        ++n;
                        ++n3;
                        continue;
                    }
                    if (this.sgp.parse(c, cArray, n, n2) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n - charBuffer.arrayOffset());
                byteBuffer.position(n3 - byteBuffer.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (c < '\u0080') {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        ++n;
                        continue;
                    }
                    if (this.sgp.parse(c, charBuffer) < 0) {
                        CoderResult coderResult = this.sgp.error();
                        return coderResult;
                    }
                    CoderResult coderResult = this.sgp.unmappableResult();
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            if (charBuffer.hasArray() && byteBuffer.hasArray()) {
                return this.encodeArrayLoop(charBuffer, byteBuffer);
            }
            return this.encodeBufferLoop(charBuffer, byteBuffer);
        }

        @Override
        protected void implReplaceWith(byte[] byArray) {
            this.repl = byArray[0];
        }

        @Override
        public int encode(char[] cArray, int n, int n2, byte[] byArray) {
            int n3 = 0;
            int n4 = n + Math.min(n2, byArray.length);
            while (n < n4) {
                char c;
                if ((c = cArray[n++]) < '\u0080') {
                    byArray[n3++] = (byte)c;
                    continue;
                }
                if (Character.isHighSurrogate(c) && n < n4 && Character.isLowSurrogate(cArray[n])) {
                    if (n2 > byArray.length) {
                        ++n4;
                        --n2;
                    }
                    ++n;
                }
                byArray[n3++] = this.repl;
            }
            return n3;
        }
    }
}

